% Dynamic OCT methods for Fig. 2 and Vis. 1
%
% Biomedical Optics Express paper titled:
% Review of dynamic optical coherence tomography for intracellular motility: 
%    Signals, metrics, and their applications 
%
% Amy Josefsberg, June, 2025

function [outImg] = func_Var(imgStack)
% Eq. (S23)
    n = size(imgStack,3); 
    meanS = mean(imgStack,3); 
    outImg = (sum(abs(imgStack).^2, 3) / n) - abs(meanS).^2;

end