% Dynamic OCT methods for Fig. 2 and Vis. 1
%
% Biomedical Optics Express paper titled:
% Review of dynamic optical coherence tomography for intracellular motility: 
%    Signals, metrics, and their applications 
%
% Amy Josefsberg, June, 2025

function [outImg] = func_LIV(imgStack,thresval)
% Eq. (7)
    n = size(imgStack,3); 
    % imgStack is often converted from uint16, to avoid negative infinity 
    % set zeros to threshold value before taking log
    SdB = 10*log10(max(imgStack,thresval)); 
    meanSdB = mean(SdB,3); 
    outImg = sum(SdB.^2, 3) / n - meanSdB.^2;

end